
//
//	Simulate drawing on Windows
//
//	It is not compatibility 100%
//
//
#include "stdafx.h"
#include "defsfile.h"


#define GP_TILEING_PATTAN_MAX 9

static CBitmap BitmapTile[GP_TILEING_PATTAN_MAX] ;			// Tile pattern with BITMAP

////////////////////////////////////////////////////////////////////////////
//  Init
//
BOOL InitGpWin()
{
	int i ;
	//	Load the bitmap for tile patten
	for( i = 0 ; i < GP_TILEING_PATTAN_MAX ; i++ ){
		if( !BitmapTile[i].LoadBitmap(IDB_TILE0+i) ){
			return( FALSE );
		}
	}
	return( TRUE );
}

////////////////////////////////////////////////////////////////////
// Convert color
//
COLORREF GpToWinColor(GPCOLOR c)
{
	static COLORREF crColors[] = {
		RGB_BLACK,
		RGB_BLUE,
		RGB_GREEN,
		RGB_CYAN,
		RGB_RED,
		RGB_MEGENTA,
		RGB_YELLOW,
		RGB_WHITE
	} ;
	return( crColors[c & 0x7] ) ;
} 



//////////////////////////////////////////////////////////////////////////
//	Constractor for create the windows bruch from tile pattern
//
CGpWinBrush::CGpWinBrush(GPTILE cTile)
{
	CreatePatternBrush( &BitmapTile[cTile] );
}


//////////////////////////////////////////////////////////////////////////
//	Constractor for create the windows bruch from tile pattern
//
CGpWinPen::CGpWinPen(GPCOLOR cColor,GPLINESTYLE cLineStyle)
{
	static struct {
		int nPenStyle ;
		int nWidth ;
	} Pens[] = {
		PS_SOLID 		| PS_GEOMETRIC | PS_ENDCAP_SQUARE |	PS_JOIN_BEVEL	,1,		// Solid Line
	 	PS_DOT   		| PS_GEOMETRIC | PS_ENDCAP_SQUARE |	PS_JOIN_BEVEL	,1,		// Dotted Lne
		PS_DASHDOT  	| PS_GEOMETRIC | PS_ENDCAP_SQUARE |	PS_JOIN_BEVEL	,1,		// One-Dot Dashed Line
		PS_DASHDOTDOT	| PS_GEOMETRIC | PS_ENDCAP_SQUARE |	PS_JOIN_BEVEL	,1,		// Two-Dots Dashed Line
	
		PS_SOLID 		| PS_GEOMETRIC | PS_ENDCAP_SQUARE |	PS_JOIN_BEVEL	,2,		// 2Dots:Solid Line
	 	PS_DOT   		| PS_GEOMETRIC | PS_ENDCAP_SQUARE |	PS_JOIN_BEVEL	,2,		// 2Dots:Dotted Lne
		PS_DASHDOT  	| PS_GEOMETRIC | PS_ENDCAP_SQUARE |	PS_JOIN_BEVEL	,2,		// 2Dots:One-Dot Dashed Line
		PS_DASHDOTDOT	| PS_GEOMETRIC | PS_ENDCAP_SQUARE |	PS_JOIN_BEVEL	,2,		// 2Dots:Two-Dots Dashed Line

		PS_SOLID 		| PS_GEOMETRIC | PS_ENDCAP_SQUARE |	PS_JOIN_BEVEL	,3,		// 3Dots:Solid Line
		PS_SOLID 		| PS_GEOMETRIC | PS_ENDCAP_SQUARE |	PS_JOIN_BEVEL	,5,		// 5Dots:olid Line
	} ;

	LOGBRUSH Brush ;
	Brush.lbStyle = BS_SOLID ;
	Brush.lbColor = GpToWinColor(cColor) ; 
	Brush.lbHatch = HS_HORIZONTAL ;

	CreatePen( Pens[cLineStyle].nPenStyle,Pens[cLineStyle].nWidth,&Brush);
}


//
//  Display NOT Line
//
void InvertLine(CDC* pDC, int iX1,int iY1,int iX2,int iY2)
{
    int nOldMode = pDC->SetROP2(R2_NOT);

    pDC->MoveTo(iX1,iY1);
    pDC->LineTo(iX2,iY2);

    pDC->SetROP2(nOldMode);
}


//
//  Display NOT BOX
//
void InvertBox(CDC* pDC, int iX1,int iY1,int iX2,int iY2)
{
    int nOldMode = pDC->SetROP2(R2_NOT);

    pDC->MoveTo(iX1,iY1);
    pDC->LineTo(iX1,iY2);
    pDC->LineTo(iX2,iY2);
    pDC->LineTo(iX2,iY1);
    pDC->LineTo(iX1,iY1);

	pDC->SetROP2 (nOldMode);
}


//
//  Display NOT Circle
//
void InvertCircle(CDC* pDC, int iX1,int iY1,int iR)
{
    int nOldMode = pDC->SetROP2(R2_NOT);

	int x1,y1,x2,y2 ;
	x1 = iX1 - iR ; y1 = iY1 - iR ;
	x2 = iX1 + iR ; y2 = iY1 + iR ;
	pDC->Arc(x1,y1,x2,y2, x2,iY1,x2,iY1);

	pDC->SetROP2 (nOldMode);
}



//
//  Display Arg
//
void AngleArc(CDC* pDC,int iX1,int iY1,int iRadius,int iSd, int iEd)
{
	double rS = RND( iSd ) ;
	double rE = RND( iEd ) ;

	double r = (double)iRadius ;
	int sx,sy ;
	int ex,ey ;

	sx = (int )(r * cos( rS )) ; sy = (int )(r * sin( rS )) ;
	ex = (int )(r * cos( rE )) ; ey = (int )(r * sin( rE )) ;

	int x1,y1,x2,y2 ;
	x1 = iX1 - iRadius ;	y1 = iY1 - iRadius ;
	x2 = iX1 + iRadius ;	y2 = iY1 + iRadius ;
	pDC->Arc(x1,y1,x2,y2,iX1 + sx,iY1 - sy,iX1 + ex,iY1 - ey);
}


//
//  Display Pie
//
void AnglePie(CDC* pDC,int iX1,int iY1,int iRadius,int iSd, int iEd)
{
	double rS = RND( iSd ) ;
	double rE = RND( iEd ) ;

	double r = (double)iRadius ;
	int sx,sy ;
	int ex,ey ;

	// To left
	sx = (int )(r * cos( rS )) ; sy = (int )(r * sin( rS )) ;
	ex = (int )(r * cos( rE )) ; ey = (int )(r * sin( rE )) ;

	int x1,y1,x2,y2 ;
	x1 = iX1 - iRadius ;	y1 = iY1 - iRadius ;
	x2 = iX1 + iRadius ;	y2 = iY1 + iRadius ;
	pDC->Pie(x1,y1,x2,y2,iX1 + sx,iY1 - sy,iX1 + ex,iY1 - ey);
}


//
//  Display NOT Arc
//
void InvertArc(CDC* pDC,int iX1,int iY1,int iRadius,int iSd, int iEd)
{
    int nOldMode = pDC->SetROP2(R2_NOT);

	AngleArc(pDC,iX1,iY1,iRadius,iSd,iEd);

    pDC->SetROP2(nOldMode);
}

// Display Start and End Angle With Line
void AngleLine(CDC* pDC,int iX1,int iY1, int iRadius, int iAngle)
{
	double rAngle = RND( iAngle ) ;
	double r = (double)iRadius ;

    pDC->MoveTo(iX1,iY1);
    pDC->LineTo(iX1 + (int)(r * cos(rAngle)) ,iY1 -(int)( r * sin(rAngle)) ) ;
}

// Display Start and End Angle With Line
void InvertAngleLine(CDC* pDC,int iX1,int iY1, int iRadius, int iAngle)
{
    int nOldMode = pDC->SetROP2(R2_NOT);

	AngleLine(pDC,iX1,iY1,iRadius,iAngle);

    pDC->SetROP2(nOldMode);
}


// Paint Mark
void InvertPaintMark(CDC* pDC,int iX1,int iY1)
{
    int nOldMode = pDC->SetROP2(R2_NOT);

	pDC->RoundRect(iX1-8,iY1-8,iX1+8,iY1+8,4,4);

	pDC->SetROP2(nOldMode);
}

//	Get Display String Size
void GPWinGetFontSize(LPCTSTR pText,int iFont,int iTurn,int iDirection,GPFONTSIZE cFontSize,int *pX,int* pY)
{
	// Shift JIS - Code:992
	static struct {
		int x,y ;
	} FontSizeTbl[] = {
		8 ,8,		// 1/4
		8,16,		// 1/2
		8,16,		// Full Japanese
		6 ,10,		// 5x7 TCP
		8 ,13,		// 7x9 TCP
		13,23,		// 11x16 TCP
		28,50,		// 24x32 TCP
		8 ,13,		// 7x9 TCP
		13,23,		// 11x16 TCP
		8 ,8		// 1/2 Japanese
	} ;

	//	Get String length
	int iLen = strlen(PCHAR(pText))/* / 2*/ ;
	if( iLen < 1)
		iLen = 1 ;
	
	// Get font size
	int x = FontSizeTbl[iFont & 0x3F].x <<  (cFontSize & 0x3) ;
	int y = FontSizeTbl[iFont & 0x3F].y <<  ((cFontSize >> 4) & 0x3) ;

	if( iDirection ){
		// |
		y *= iLen ;
	} else {
		// -
		x *= iLen ;
	}

	// Turn
	if( iDirection )
	{
		switch( iTurn ){
			case 0: // 0
				*pX = y ;
				*pY = -x ;
				break ;

			case 1:	// 90
				*pX = -x ;
				*pY = -y ;
				break ;

			case 2:	// 180
				*pX = -y ;
				*pY = x ;
				break ;

			case 3:	// 270
				*pX = x ;
				*pY = y ;
				break ;
		}
	}
	else
	{
		switch( iTurn ){
			case 0: // 0
				*pX = x ;
				*pY = -y ;
				break ;

			case 1:	// 90
				*pX = -y ;
				*pY = -x ;
				break ;

			case 2:	// 180
				*pX = -x ;
				*pY = y ;
				break ;

			case 3:	// 270
				*pX = y ;
				*pY = x ;
				break ;
		}
	}
}
